function MapProviderServicesToUserQuery(selectedProviderServiceIds) {

    debugger;
    //Define WebAPIURL for userQuery creation here. 
    var orgUrl = window.parent.Xrm.Page.context.getClientUrl();
    var webAPIUrl = orgUrl + "/api/data/v8.2/";
    var customParameters;
    //Define the start of the FetchXml here for the user query we will create. 
    var fetchXml = new String();
    fetchXml =
        '<fetch version="1.0" output-format="xml-platform" mapping="logical" distinct="true">' +
        '<entity name="ppms_providerservice">' +
        '<attribute name="ppms_name"/>' +
        '<attribute name="ppms_caresiteaddress" />' +
        '<attribute name="ppms_caresitecity" />' +
        '<attribute name="ppms_caresitestateprovince" />' +
        '<attribute name="ppms_caresitezipcode" />' +
        '<attribute name="ppms_latitude" />' +
        '<attribute name="ppms_longitude" />' +
        '<attribute name="ppms_specialtynametext" />' +
        '<attribute name="ppms_providername" />' +
        '<attribute name="ppms_providerid" />' +
        '<attribute name="ppms_providerserviceid" />' +
        '<order attribute="ppms_name" descending="false" />' +
        '<filter type="and">' +
        '<condition attribute="ppms_providerserviceid" operator="in">';
    for (var i = 0; i < selectedProviderServiceIds.length; i++) {
        //Format the ID to remove braces
        var ProviderServiceId = selectedProviderServiceIds[i].toString();
        ProviderServiceId = ProviderServiceId.replace(/[{}]/g, "");
        fetchXml +=
            '<value uiname="" uitype="ppms_providerservice">{' + ProviderServiceId + '}</value>';
    }
    //Close out the FetchXml
    fetchXml += '</condition ></filter ></entity> </fetch >';
        
    var userQuery = JSON.stringify({
        "name": "User Defined Provider Query",
        "description": "User Defined Provider Query from Options Selected.",
        "returnedtypecode": "ppms_providerservice",
        "fetchxml": fetchXml,
        "querytype": 0
    });
    $.ajax({
        type: "POST",
        contentType: "application/json; charset=utf-8",
        datatype: "json",
        url: webAPIUrl + "userqueries",
        data: userQuery,
        beforeSend: function (XMLHttpRequest) {
            //Specifying this header ensures that the results will be returned as JSON.             
            XMLHttpRequest.setRequestHeader("Accept", "application/json");
        },
        success: function (data, textStatus, xhr) {
            //var userQueryIdUrl = xhr.getResponseHeader("Odata-EntityId");
            var parseQuery = /\(([^)]+)\)/;
            var queryMatches = parseQuery.exec(xhr.getResponseHeader("Odata-EntityId"));
            userQueryId = queryMatches[1];

            //Pass in the userQueryId in Custom Parameters? 
            customParameters = encodeURIComponent(userQueryId);
            OpenMap(customParameters);

        },
        error: function (e) {
            showErrorMsg('Unable to generate Query');
        }
    }); 
}

function OpenMap(customParameters) {
    if (customParameters != null)
        Xrm.Utility.openWebResource("ppms_selectedproviderservicesmap.html", customParameters);
}

//Old method which added all the ID's into custom param URL // Depricated.
function MapProviderServices(selectedProviderServiceIds) {

    debugger;
    //Create the custom Parameters that we will pass in the Providers to. 
    var customParameters = new String();

    for (var i = 0; i < selectedProviderServiceIds.length; i++) {
        //Format the ID to remove braces
        var ProviderServiceId = selectedProviderServiceIds[i].toString();
        ProviderServiceId = ProviderServiceId.replace(/[{}]/g, "");
        customParameters += (i + 1);
        customParameters += "=";
        customParameters += ProviderServiceId;
        if (i != selectedProviderServiceIds.length - 1) {
            customParameters += "&";
        } else {
            customParameters = encodeURIComponent(customParameters);
            Xrm.Utility.openWebResource("ppms_selectedproviderservicesmap.html", customParameters);
        }
    }
}

        
